import pandas as pd  
from sklearn.model_selection import train_test_split   
import pickle
from decision_company import read_csv_file, divide_dataset

# Load the dataset    
credit_customers = read_csv_file("credit_customers.csv") 
  
# Split the dataset into training and testing sets    
X_train, X_test, y_train, y_test = divide_dataset(X, y, test_size=0.2, random_state=42)  
  
print(X_train)
pickle.dump(X_train,open("./ref_result/X_train.pkl","wb"))
print(X_test)
pickle.dump(X_test,open("./ref_result/X_test.pkl","wb"))
print(y_train)
pickle.dump(y_train,open("./ref_result/y_train.pkl","wb"))
print(y_test)
pickle.dump(y_test,open("./ref_result/y_test.pkl","wb"))

  